<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Location extends Model 
{

    protected $table = 'locations';
    public $timestamps = true;
    protected $fillable = array('address', 'address2', 'city', 'state', 'phone', 'email', 'website', 'country', 'nickname', 'date_opened', 'quickbase_id', 'zipcodes_id');
    protected $visible = array('address', 'address2', 'city', 'state', 'phone', 'email', 'website', 'country', 'nickname', 'date_opened', 'quickbase_id', 'zipcodes_id');

    public function clinic()
    {
        return $this->belongsTo('Clinic');
    }

    public function zipcode()
    {
        return $this->hasOne('Zipcode');
    }

    public function website()
    {
        return $this->hasOne('Website');
    }

    public function profile()
    {
        return $this->belongsTo('Profile');
    }

}